package treeNAlgo;

import treeN.*;
import java.util.*;
import extvisitor.*;

/**
 * FindNAlgo2 - finds the sub-tree and data position of the given key in the tree
 * 
 *  Utilizes lambda-based extended visitors
 * Return value is an Object array where 
 * return[0] is the sub-tree headed by the desired key.  Empty tree if not found.
 * return[1] is the index of the data position of the desired key.  -1 if it was not found.
 */
public class FindNAlgo2<E> extends ATreeNAlgo<E, Object[], E> {
  
  private Comparator<E> comp = new Comparator<E>() {
    public int compare(E o1, E o2) {
      return ((Comparable<E>)o1).compareTo(o2);
    }
  };
  
  public FindNAlgo2() {
    System.out.println("FindNAlgo2 instantiated.");

    setCmd(0,new IExtVisitorCmd<Object[],Integer, E, TreeN<E>>(){
      public Object[] apply(Integer index, TreeN<E> host, E... keys) {
        //System.err.println("Key "+key+" not found in tree.");
        return new Object[]{host, -1};
      }
    });   

    setDefaultCmd(new IExtVisitorCmd<Object[],Integer, E, TreeN<E>>(){      
      public Object[] apply(Integer index, final TreeN<E> host, final E... keys) {
        int x=0;
        for(; x < index; x++) {// find child index
          E d = host.getDat(x);
          int compVal = comp.compare(d, keys[0]);
          if(0 == compVal) {
            //System.out.println("Found "+key+"!");
            return new Object[]{host, x};
          } 
          else if (0 < compVal) {
            break;
          }
        }
        return host.getChild(x).execute(FindNAlgo2.this, keys);
      }
    });
  }
}
